//
// TTSNotifySink.cpp : Cve[V t@C
//
// Copyright (C)1995-2001 TOSHIBA Corporation, All Rights Reserved.
//

#include "stdafx.h"

#include <SPEECH.H>					// Microsoft Speech SDK V3.0 wb_t@C
#include "tossapi.h"	// LaLaVoice wb_t@C

#include "impiunk.h"
#include "TTSNotifySink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTTSNotifySink

IMPLEMENT_DYNCREATE(CTTSNotifySink, CCmdTarget)

CTTSNotifySink::CTTSNotifySink()
{
	m_hWndNotify = NULL;
}

CTTSNotifySink::~CTTSNotifySink()
{
}


BEGIN_MESSAGE_MAP(CTTSNotifySink, CCmdTarget)
	//{{AFX_MSG_MAP(CTTSNotifySink)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_INTERFACE_MAP(CTTSNotifySink, CCmdTarget)
	INTERFACE_PART(CTTSNotifySink, IID_ITTSNotifySinkA, TTSNotifyObjectA)
	INTERFACE_PART(CTTSNotifySink, IID_ITTSNotifySinkW, TTSNotifyObjectW)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTTSNotifySink bZ[W nh

void CTTSNotifySink::OnFinalRelease() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	CCmdTarget::OnFinalRelease();
}


/////////////////////////////////////////////////////////////////////////////
// ITTSNotifySinkA C^[tFCX

IMPLEMENT_IUNKNOWN(CTTSNotifySink, TTSNotifyObjectA)

// ITTSNotifySink::AttribChanged
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectA::AttribChanged(DWORD dwAttribute)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectA)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_ATTRIBCHANGED, dwAttribute, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::AudioStart
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectA::AudioStart(QWORD qTimeStamp)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectA)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_AUDIOSTART, 0, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::AudioStop
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectA::AudioStop(QWORD qTimeStamp)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectA)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_AUDIOSTOP, 0, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::Visual
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectA::Visual(QWORD qTimeStamp, CHAR cIPAPhoneme, CHAR cEnginePhoneme, DWORD dwHints, PTTSMOUTH pTTSMouth)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectA)

	int nTime = GetTickCount();
	/*
	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		// TTSMOUTH\̂̃f[^WPARAM, LPARAMɕϊ
		WPARAM wParam = MAKELONG(MAKEWORD(pTTSMouth->bJawOpen, pTTSMouth->bMouthUpturn), MAKEWORD(pTTSMouth->bMouthWidth, pTTSMouth->bMouthHeight));
		LPARAM lParam = MAKELONG(MAKEWORD(pTTSMouth->bLipTension, pTTSMouth->bTonguePosn), MAKEWORD(pTTSMouth->bTeethLowerVisible, pTTSMouth->bTeethUpperVisible));

		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_VISUAL, wParam, lParam);
	}
	*/

	::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_VISUAL, NULL, (LPARAM)nTime);
	
	return NOERROR;	// Return value is ignored.
}

/////////////////////////////////////////////////////////////////////////////
// ITTSNotifySinkW C^[tFCX

IMPLEMENT_IUNKNOWN(CTTSNotifySink, TTSNotifyObjectW)

// ITTSNotifySink::AttribChanged
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectW::AttribChanged(DWORD dwAttribute)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectW)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_ATTRIBCHANGED, dwAttribute, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::AudioStart
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectW::AudioStart(QWORD qTimeStamp)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectW)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_AUDIOSTART, 0, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::AudioStop
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectW::AudioStop(QWORD qTimeStamp)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectW)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_AUDIOSTOP, 0, 0);
	}
	return NOERROR;	// Return value is ignored.
}

// ITTSNotifySink::Visual
STDMETHODIMP CTTSNotifySink::XTTSNotifyObjectW::Visual(QWORD qTimeStamp, WCHAR cIPAPhoneme, WCHAR cEnginePhoneme, DWORD dwHints, PTTSMOUTH pTTSMouth)
{
	METHOD_PROLOGUE(CTTSNotifySink, TTSNotifyObjectW)

	if (IsWindowEnabled(pThis->m_hWndNotify)) {
		// TTSMOUTH\̂̃f[^WPARAM, LPARAMɕϊ
		WPARAM wParam = MAKELONG(MAKEWORD(pTTSMouth->bJawOpen, pTTSMouth->bMouthUpturn), MAKEWORD(pTTSMouth->bMouthWidth, pTTSMouth->bMouthHeight));
		LPARAM lParam = MAKELONG(MAKEWORD(pTTSMouth->bLipTension, pTTSMouth->bTonguePosn), MAKEWORD(pTTSMouth->bTeethLowerVisible, pTTSMouth->bTeethUpperVisible));

		::PostMessage(pThis->m_hWndNotify, WM_TTSNOTIFY_VISUAL, wParam, lParam);
	}

	return NOERROR;	// Return value is ignored.
}

